/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  double precision pwm.c
*  :  XuQP
*  :  V1.0
*  :  2020/3/11
*  :  T20˫PWM
          1.ʹоƬ˫PWMģʽPC0˿ڼPC1˿ʵΪ100us~50usռձȷֱΪ25%50%ķڷĴεݼ50us
            ٽװأռձȲ䣬Դη
          2.оƬʹ16MHzϵͳʱӣӦT20ʱʱԴΪ1/16MHzT20ԤƵã1:1T20ڼĴT20Pʼֵ㹫ʽӦΪ
            PWM100us = T20P 1/16MHz 1ԤƵȣT20PֵPERIOD = 16000x0640
            PWM50us = T20PR 1/16MHz 1ԤƵȣT20RֵDUTY21 = 8000x0320PC1˿ڵΪ
            PWMռձ50% = T20R / T20P
*  ע:  ES7PH202x
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

void RAMClear(void);

#define PERIOD 1600
#define DUTY21 800
#define DUTY20 400

unsigned int N_Period;
unsigned int N_Duty20;
unsigned int N_Duty21;

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void isr(void) interrupt
{
    if(T20PIE &&T20PIF) 
    {                                   //T20ж
        T20PIF = 0;
        if(N_Period >=1000)
        {
            N_Period-= 200;
            N_Duty20 -= 50;
            N_Duty21 -= 100;   
            
            T20PH = N_Period>>8;
            T20PL = N_Period;            //PWM
            
            T20R1H = N_Duty21 >> 8;
            T20R1L = N_Duty21;           //PWM
            
            T20R0H = N_Duty20 >> 8;
            T20R0L = N_Duty20;           //PWM
        }
        else
        {
            N_Period = PERIOD;
            N_Duty20 = DUTY20;
            N_Duty21 = DUTY21;
            
            T20PH = N_Period>>8;
            T20PL = N_Period;            //PWM
            
            T20R1H = N_Duty21 >> 8;
            T20R1L = N_Duty21;           //PWM
            
            T20R0H = N_Duty20 >> 8;
            T20R0L = N_Duty20;           //PWM
        }
    }
}

/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main()
{
    RAMClear();                 //RAM

    PC0 = 0;                    //PC0˿͵ƽ
    PCT0= 0; 		            //PC0˿Ϊ  
    PC1 = 0;                    //PC1˿͵ƽ
    PCT1= 0; 		            //PC1˿Ϊ      
    PCS = 0x00;                 //PCΪI/O

    N_Period = PERIOD;
    N_Duty20 = DUTY20;
    N_Duty21 = DUTY21;
    
    T20CL = 0xC1;		        //T20˫PWMģʽ
    T20PS = 0;                  //òΪPC0PC1
    T2NOC = 0x03;		        //ʹPWM
    
    T20CM = 0x00;		        //T20ԤƵƵ    
    T20PH = N_Period >> 8;
    T20PL = N_Period;           //
    
    T20R1H = N_Duty21 >> 8;
    T20R1L = N_Duty21;          //þ
    T20R0H = N_Duty20 >> 8;    
    T20R0L = N_Duty20;          //þ
    
    T20CH = 0x80;		        //ʹT20
    T20PIE = 1; 		        //ʹT20ж
    GIE = 1;		            //ʹȫж 
    while(1);
}

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
	__asm{				    //ַ0x0000~0x05FF
		MOVI 0x00			
		MOVA IAAH 
		MOVI 0x00			
		MOVA IAAL 
		CLR	 IAD 
		INC	 IAAL,1
		JBS	 PSW,C
		GOTO $-3
		INC IAAH,1
		MOVI 0x06
		SUB  IAAH,0
		JBS	 PSW,C	
		GOTO $-8
	}
}
